<?php

namespace App\Filament\Resources\AdminUserResource\Pages;

use App\Filament\Resources\AdminUserResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;

class ListAdminUsers extends ListRecords
{
    protected static string $resource = AdminUserResource::class;

    protected function getHeaderActions(): array
    {
          return [
            Actions\CreateAction::make()
                ->visible(fn () => auth()->user()?->hasRole(\App\Enums\Role::admin->value)),
        ];
    }
}
