<?php

namespace App\Filament\Resources\AdminUserResource\Pages;

use App\Filament\Resources\AdminUserResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use App\Enums\Role;
use Filament\Notifications\Notification;

class EditAdminUser extends EditRecord
{
    protected static string $resource = AdminUserResource::class;
    protected ?string $roleToSync = null;

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $data['role'] = $this->record->roles()->pluck('name')->first() ?: Role::ContentCreator->value;
        return $data;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $this->roleToSync = $data['role'] ?? null;
        unset($data['role']);

        return $data;
    }

    protected function afterSave(): void
    {
        $role = $this->roleToSync;

        if (
            $this->record->is(auth()->user())
            && $this->record->hasRole(Role::admin->value)
            && $role !== Role::admin->value
        ) {
            $this->record->syncRoles([Role::admin->value]);

            Notification::make()
                ->title(__("You can't remove your own Admin role."))
                ->danger()
                ->send();

            return;
        }

        if ($role) {
            $allowed = [Role::admin->value, Role::ContentCreator->value];
            $this->record->syncRoles(in_array($role, $allowed, true) ? [$role] : [Role::ContentCreator->value]);
        }
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
