<?php

namespace App\Filament\Resources\AdminUserResource\Pages;

use App\Filament\Resources\AdminUserResource;
use Filament\Resources\Pages\CreateRecord;
use App\Enums\Role;

class CreateAdminUser extends CreateRecord
{
    protected static string $resource = AdminUserResource::class;

    protected ?string $roleToSync = null;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $this->roleToSync = $data['role'] ?? null;
        unset($data['role']);

        return $data;
    }

    protected function afterCreate(): void
    {
        $role = $this->roleToSync ?: Role::ContentCreator->value;

        $allowed = [Role::admin->value, Role::ContentCreator->value];
        $this->record->syncRoles(in_array($role, $allowed, true) ? [$role] : [Role::ContentCreator->value]);
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
