<?php

namespace App\Filament\Pages;

use App\Support\YourPackagePage;
use Exception;
use Filament\Forms\Form;
use Filament\Forms;
use Filament\Pages\Page;
use Illuminate\Contracts\Support\Htmlable;
use Filament\Actions\Action;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class YourPackage extends Page
{
    protected static ?string $navigationIcon = "heroicon-o-star";

    protected static string $view = "filament.pages.your-package";

    public static function canAccess(): bool
    {
        return auth()->user()?->hasRole(\App\Enums\Role::admin->value) ?? false;
    }

    public static function shouldRegisterNavigation(): bool
    {
        return auth()->user()?->hasRole(\App\Enums\Role::admin->value) ?? false;
    }

    public array $data = [];


    public static function getNavigationGroup(): ?string
    {
        return __("navigation.cms");
    }

    public function getTitle(): string|Htmlable
    {
        return __("your-package.your-package");
    }

    public static function getNavigationLabel(): string
    {
        return __("your-package.your-package");
    }

    public function mount(): void
    {
        $page = YourPackagePage::make();

        $this->form->fill([
            'tag' => $page->header()->getRaw('tag'),
            'title' => $page->header()->getRaw('title'),
            'description' => $page->header()->getRaw('description'),
        ]);
    }

    public function form(Form $form): Form
    {
        return $form->statePath("data")->schema([
            Forms\Components\Section::make(strip_tags(YourPackagePage::make()->header()->getRaw('title')[app()->getLocale()]))
                ->description(strip_tags(YourPackagePage::make()->header()->getRaw('description')[app()->getLocale()]))
                ->aside()
                ->schema([
                    Forms\Components\TextInput::make("tag")
                        ->label(__("your-package.tag-label"))
                        ->placeholder(__("your-package.tag-placeholder"))
                        ->required()
                        ->maxLength(255)
                        ->translatable(),
                    Forms\Components\TextInput::make("title")
                        ->label(__("your-package.title-label"))
                        ->placeholder(__("your-package.title-placeholder"))
                        ->required()
                        ->maxLength(255)
                        ->translatable(),
                    Forms\Components\RichEditor::make("description")
                        ->label(__("your-package.description-label"))
                        ->placeholder(__("your-package.description-placeholder"))
                        ->required()
                        ->translatable()
                ]),
        ]);
    }

    protected function getActions(): array
    {
        return [
            Action::make(__("app.update"))
                ->icon("heroicon-o-arrow-path")
                ->action(fn() => $this->publish()),
        ];
    }

    public function publish(): void
    {
        $this->validate();

        try {
            DB::beginTransaction();

            $page = YourPackagePage::make();

            $page->header()->patch([
                "tag" => $this->data["tag"],
                "title" => $this->data["title"],
                "description" => $this->data["description"],
            ]);

            Notification::make()
                ->success()
                ->title(__("app.content-update-success"))
                ->send();
            DB::commit();
        } catch (Exception $e) {
            DB::rollback();
            Log::error("Failed to update Your Package data", [
                "message" => $e->getMessage(),
                "trace" => $e->getTraceAsString(),
            ]);

            Notification::make()
                ->danger()
                ->title(__("app.content-update-failure"))
                ->send();
        }
    }
}
